import IGenericOrderGetOrderApiResponse from 'server/api/GenericOrderApi/types/getOrder/IGenericOrderGetOrderApiResponse';
import IRefundPartCtx from 'server/api/GenericOrderApi/types/common/refund/IRefundPartCtx';

import {getFirstTrainService} from 'projects/trains/lib/complexOrder/getFirstTrainService';

/**
 * Достаем контексты для возврата из сложного заказа по выбранным билетам или всего заказа
 * @param order
 * @param blankIds идентификаторы билетов
 */
export default function getRefundPartContexts(
    order: IGenericOrderGetOrderApiResponse | null,
    blankIds?: string[],
): IRefundPartCtx[] {
    if (!order) {
        throw new Error('generic order is null');
    }

    if (blankIds?.length) {
        const trainService = getFirstTrainService(order);

        if (!trainService) {
            throw new Error('Train generic service expected');
        }

        const passengers = trainService.trainInfo.passengers;

        if (!passengers) {
            throw new Error('passengers is undefined');
        }

        return blankIds.map(blankId => {
            const passenger = passengers.find(
                p => String(p.ticket?.blankId) === blankId,
            );

            const context = passenger?.refundPartInfo?.context;

            if (!context) {
                throw new Error('refundPartInfo.context for passenger');
            }

            return context;
        });
    }

    const orderRefundContext = order?.refundPartInfo?.context;

    if (!orderRefundContext) {
        throw new Error('refundPartInfo.context is undefined');
    }

    return [orderRefundContext];
}
