import moment from 'moment-timezone';

import {getNow} from 'utilities/dateUtils';

const THREE_MINUTES_IN_MILLISECONDS = 3 * 60 * 1000;

/**
 * Функция возвращает, сколько миллисекунд осталось до изменения суммы возврата билета/билетов.
 *
 * @see https://st.yandex-team.ru/TRAVELFRONT-1471
 */
export default function getMillisecondsUntilRefundAmountChange(
    departure: string,
): number {
    const nowMoment = moment(getNow());
    const departureMoment = moment(departure);
    /*
     * Добавляем по одной минуте, т.к. есть лаг и обновленная сумма возврата приходит как раз примерно через минуту.
     */
    const twoHoursBeforeDepartureMoment = moment(departureMoment)
        .subtract(2, 'hours')
        .add(1, 'minute');
    const eightHoursBeforeDepartureMoment = moment(departureMoment)
        .subtract(8, 'hours')
        .add(1, 'minute');

    return [
        twoHoursBeforeDepartureMoment,
        eightHoursBeforeDepartureMoment,
    ].reduce((minMilliseconds, refundAmountChangingMoment) => {
        const millisecondsUtilRefundAmountChangingMoment =
            refundAmountChangingMoment.diff(nowMoment);

        if (
            millisecondsUtilRefundAmountChangingMoment >= 0 &&
            millisecondsUtilRefundAmountChangingMoment <=
                THREE_MINUTES_IN_MILLISECONDS &&
            millisecondsUtilRefundAmountChangingMoment < minMilliseconds
        ) {
            return millisecondsUtilRefundAmountChangingMoment;
        }

        return minMilliseconds;
    }, Infinity);
}
