import {
    call,
    takeEvery,
    take,
    takeLatest,
    put,
    race,
    all,
    select,
} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {SagaIterator} from 'redux-saga';

import EAviaDynamicActionLogActionName from 'server/loggers/avia/AviaActionLog/types/EAviaDynamicActionLogActionName';

import {loggerActions} from 'reducers/avia/aviaLogging/actions';
import {
    initSearch,
    setTDAnswer,
    stopSearch,
} from 'reducers/avia/search/results/actions';
import {weekPricesSearchSuccess} from 'reducers/avia/aviaPriceIndex/weekPrices/actions';

import aviaDynamicLogSelector from 'selectors/avia/search/aviaDynamicLogSelector';
import {searchIsCompleteSelector} from 'selectors/avia/order/aviaOrderSelector';

import {logAction} from 'projects/avia/lib/logging/aviaVariantsLogger';
import {unknownToError} from 'utilities/error';

import reportError from './reportError';

/**
 * Обрабатывает записи в action-лог записей для динамики цен
 */
function* handleLogAction({
    payload,
}: ActionType<typeof loggerActions.logDynamicAction>) {
    try {
        const params: ReturnType<typeof aviaDynamicLogSelector> = yield select(
            aviaDynamicLogSelector,
        );

        yield call(logAction, payload.name, {
            ...params,
            ...payload.params,
        });
    } catch (err) {
        reportError(unknownToError(err), 'Ошибка записи action лога');
    }
}

/**
 * Логирует статус динамики по мере получения цен
 */
function* handleDynamicState() {
    yield all([
        take(getType(weekPricesSearchSuccess)),
        take(getType(setTDAnswer)),
    ]);

    while (true) {
        const isComplete: ReturnType<typeof searchIsCompleteSelector> =
            yield select(searchIsCompleteSelector);

        if (isComplete) {
            yield put(
                loggerActions.logDynamicAction({
                    name: EAviaDynamicActionLogActionName.DYNAMIC_FINAL_STATE,
                }),
            );

            break;
        } else {
            yield put(
                loggerActions.logDynamicAction({
                    name: EAviaDynamicActionLogActionName.DYNAMIC_STATE,
                }),
            );
        }

        yield race([take(getType(setTDAnswer)), take(getType(stopSearch))]);
    }
}

export default function* (): SagaIterator {
    yield takeEvery(getType(loggerActions.logDynamicAction), handleLogAction);
    yield takeLatest(getType(initSearch), handleDynamicState);
}
