import {logError} from 'utilities/logger/logError';
import appData from 'utilities/appData/appData';

export default function reportError(err: Error, message: string) {
    if (!appData.isProductionEnv) {
        logError(
            {
                message: `[YATRAVEL][AVIA] ${message}`,
                block: 'aviaSearchLoggingSaga',
            },
            err,
        );
    }
}
