import {all} from 'redux-saga/effects';

import fetchDataSaga from './fetchDataSaga';
import orderStateWatcher from './orderStatePollingSaga';
import createOrderSaga from './createOrderSaga';
import initPaymentSaga from './initPaymentSaga';
import fetchOrderSaga from './fetchOrderSaga';
import confirmationCompleteSaga from './confirmationCompleteSaga';

export default function* () {
    yield all([
        fetchDataSaga(),
        createOrderSaga(),
        orderStateWatcher(),
        initPaymentSaga(),
        fetchOrderSaga(),
        confirmationCompleteSaga(),
    ]);
}
