import {takeEvery, call} from 'redux-saga/effects';
import {getType, ActionType} from 'typesafe-actions';

import {confirmationComplete} from 'reducers/avia/booking/orderPayment/actions';

import {bookingApiClient} from 'projects/avia/pages/AviaBooking/api/bookingApiClient';

function* handleConfirmationComplete({
    payload,
}: ActionType<typeof confirmationComplete>) {
    try {
        yield call(bookingApiClient.confirmationComplete, payload);
    } catch (ex) {
        console.error('Confirmation complete request failed', ex);
    }
}

export default function* confirmationCompleteSaga() {
    yield takeEvery<ActionType<typeof confirmationComplete>>(
        getType(confirmationComplete),
        handleConfirmationComplete,
    );
}
