import {getType} from 'typesafe-actions';
import {takeEvery, all, call, put} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';

import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';
import {ITravelerNotebook} from 'projects/avia/pages/AviaBooking/types/ITravelerNotebook';

import {
    requestVariant,
    setVariant,
    variantFailure,
} from 'reducers/avia/booking/variants/actions';
import {
    travellerNotebookSuccess,
    travellerNotebookFailure,
} from 'reducers/avia/booking/travellerNotebook/actions';

import {unknownToError} from 'utilities/error';

import {bookingApiClient} from 'projects/avia/pages/AviaBooking/api/bookingApiClient';
import {travelersApiClient} from 'projects/avia/pages/AviaBooking/api/travelersApiClient';

function* fetchTravelerNotebook() {
    try {
        const travellerNotebook: ITravelerNotebook = yield call(
            travelersApiClient.getNotebook,
        );

        return travellerNotebookSuccess(travellerNotebook);
    } catch (ex) {
        return travellerNotebookFailure(unknownToError(ex));
    }
}

function* fetchVariant(token: string) {
    try {
        const variants: IBookingVariantsModelType = yield call(
            bookingApiClient.variants,
            token,
        );

        return setVariant(token, variants);
    } catch (ex) {
        return variantFailure(token, unknownToError(ex));
    }
}

function* fetchBookingPageData({
    payload,
}: ReturnType<typeof requestVariant>): SagaIterator {
    const [token] = payload;
    /**
     * Начальное состояние формы зависит от записной книжки и вариантов.
     */
    const actions = yield all([
        call(fetchTravelerNotebook),
        call(fetchVariant, token),
    ]);

    for (const action of actions) {
        yield put(action);
    }
}

export default function* (): SagaIterator {
    yield takeEvery<ReturnType<typeof requestVariant>>(
        getType(requestVariant),
        fetchBookingPageData,
    );
}
