import {call, put, takeEvery} from 'redux-saga/effects';
import {ActionType, getType} from 'typesafe-actions';
import {SagaIterator} from 'redux-saga';

import EGenericOrderSource from 'server/api/GenericOrderApi/types/common/EGenericOrderSource';

import {
    orderFailure,
    requestOrder,
    setOrder,
} from 'reducers/avia/booking/orders/actions';

import {unknownToError} from 'utilities/error';

import {bookingApiClient} from 'projects/avia/pages/AviaBooking/api/bookingApiClient';

import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';

function* handleRequestOrder({
    payload: [orderId],
}: ActionType<typeof requestOrder>) {
    try {
        const order: IAviaBookingOrderPageData = yield call(
            bookingApiClient.getOrder,
            orderId,
            EGenericOrderSource.OTHER,
        );

        yield put(setOrder(orderId, order));
    } catch (ex) {
        yield put(orderFailure(orderId, unknownToError(ex)));
    }
}

export default function* (): SagaIterator {
    yield takeEvery(getType(requestOrder), handleRequestOrder);
}
