import {takeEvery, call, put} from 'redux-saga/effects';
import {getType, ActionType} from 'typesafe-actions';

import {URLs} from 'constants/urls';

import {
    initOrderPayment,
    initPaymentFailure,
} from 'reducers/avia/booking/orderPayment/actions';
import {stopStatePolling} from 'reducers/avia/booking/compositeStates/actions';

import {unknownToError} from 'utilities/error';

import {bookingApiClient} from 'projects/avia/pages/AviaBooking/api/bookingApiClient';

import {EBookingServiceDeviceType} from 'server/api/AviaBookingApi/enums/EBookingServiceDeviceType';

function* initOrderPaymentProcess({
    payload,
}: ActionType<typeof initOrderPayment>) {
    const deviceType = payload.isMobile
        ? EBookingServiceDeviceType.DT_MOBILE
        : EBookingServiceDeviceType.DT_DESKTOP;
    const redirect3dsUrl =
        window.location.origin + URLs.aviaBookingPaymentRedirectTarget;
    const redirectTrustUrl =
        window.location.origin + URLs.aviaBookingFinishPayment;

    try {
        yield call(bookingApiClient.initPaymentAsync, {
            orderId: payload.orderId,
            deviceType: deviceType,
            confirmationRedirectUrl: redirect3dsUrl,
            paymentRedirectUrl: redirectTrustUrl,
        });
    } catch (ex) {
        yield put(initPaymentFailure(unknownToError(ex)));
        yield put(stopStatePolling());
    }
}

export default function* initPaymentSaga() {
    yield takeEvery<ActionType<typeof initOrderPayment>>(
        getType(initOrderPayment),
        initOrderPaymentProcess,
    );
}
