import {takeEvery, call} from 'redux-saga/effects';
import {parse, stringify} from 'query-string';
import {ActionType, getType} from 'typesafe-actions';

import {AVIA_BAGGAGE_PARAM_KEY} from 'projects/avia/constants/queryParams';

import {aviaOrderActions} from 'reducers/avia/order/actions';

import history from 'utilities/browserHistory/browserHistory';
import {locationSearchHasBaggage} from 'projects/avia/lib/urls/queryParams';

function* baggageChangeWatcher({
    payload,
    meta,
}: ActionType<typeof aviaOrderActions.setBaggageFilter>) {
    if (history && !meta?.isInitial) {
        const hasBaggage = locationSearchHasBaggage(history.location.search);

        if (payload !== hasBaggage) {
            yield call(() => {
                history?.replace({
                    ...history.location,
                    search: `?${stringify(
                        {
                            ...parse(history.location.search),
                            [AVIA_BAGGAGE_PARAM_KEY]: Number(payload),
                        },
                        {encode: false},
                    )}`,
                });
            });
        }
    }
}

export default function* baggageFilterSaga() {
    yield takeEvery(
        getType(aviaOrderActions.setBaggageFilter),
        baggageChangeWatcher,
    );
}
