import {ActionType, getType} from 'typesafe-actions';
import {put, call, takeEvery} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';

import {IGetExtendedCountryRestrictionsResponse} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';

import {getCountryRestrictionsActions} from 'reducers/avia/countryRestrictions/actions';

import {aviaProvider} from 'serviceProvider/avia/aviaProvider';

export default function* (): SagaIterator {
    yield takeEvery(
        getType(getCountryRestrictionsActions.request),
        requestCountryRestrictions,
    );
}

function* requestCountryRestrictions({
    payload,
}: ActionType<typeof getCountryRestrictionsActions.request>): SagaIterator {
    if (payload && payload.fromPointKey && payload.toPointKey) {
        try {
            const countryRestrictionsResponse: IGetExtendedCountryRestrictionsResponse =
                yield call(
                    aviaProvider.provider().getExtendedCountryRestrictions,
                    {
                        fromPointKey: payload.fromPointKey,
                        toPointKey: payload.toPointKey,
                    },
                );

            yield put(
                getCountryRestrictionsActions.success({
                    ...countryRestrictionsResponse,
                    countryId: payload.countryId,
                }),
            );
        } catch (e) {
            yield put(getCountryRestrictionsActions.failure(e));
        }
    }
}
