import {all} from 'redux-saga/effects';

import filtersSaga from 'sagas/avia/search/filtersSaga';
import metrikaSaga from 'sagas/avia/search/metrikaSaga';
import popularsSaga from 'sagas/avia/search/popularsSaga';
import aviaOrderSaga from 'sagas/avia/order/orderRootSaga';
import aviaBookingRootSaga from 'sagas/avia/booking/bookingRootSaga';
import aviaLoggingSaga from 'sagas/avia/aviaLogging/aviaLoggingSaga';
import searchResultsRootSaga from 'sagas/avia/search/searchResultsRootSaga';
import searchSubscriptionsSaga from 'sagas/avia/search/searchSubscriptionsSaga';
import countryRescrictionsSaga from 'sagas/avia/restrictions/countryResctrictionsSaga';

export default function* rootSaga() {
    yield all([
        filtersSaga(),
        metrikaSaga(),
        popularsSaga(),
        aviaOrderSaga(),
        aviaLoggingSaga(),
        aviaBookingRootSaga(),
        searchResultsRootSaga(),
        searchSubscriptionsSaga(),
        countryRescrictionsSaga(),
    ]);
}
