import {getType} from 'typesafe-actions';
import {takeEvery, call, all} from 'redux-saga/effects';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {setResultsSorting} from 'reducers/avia/search/results/actions';

import {params, reachGoal} from 'utilities/metrika';

export function* sortingMetrikaWatcher() {
    yield takeEvery(
        getType(setResultsSorting),
        function* ({payload}: ReturnType<typeof setResultsSorting>) {
            yield call(reachGoal, EAviaGoal.SEARCH_SORT);
            params({avia: {sortType: payload.type}});
        },
    );
}

export default function* metrikaSaga() {
    yield all([sortingMetrikaWatcher()]);
}
