import {getType, ActionType} from 'typesafe-actions';
import {takeEvery, call, put} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';

import {initSearch} from 'reducers/avia/search/results/actions';
import {partnersFetchActions} from 'reducers/avia/search/results/partners/actions';
import {flightsFetchActions} from 'reducers/avia/search/results/popularFlights/actions';

import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export default function* (): SagaIterator {
    yield takeEvery(getType(initSearch), handleInitSearch);
}

function* handleInitSearch({
    payload: {query},
}: ActionType<typeof initSearch>): SagaIterator {
    yield put(partnersFetchActions.request(query));
    yield put(flightsFetchActions.request());

    try {
        const partners = yield call(
            aviaBrowserProvider.getPopularPartners,
            query,
        );

        yield put(partnersFetchActions.success(partners));
    } catch (ex) {
        console.error(ex);
        yield put(partnersFetchActions.failure());
    }

    try {
        const flights = yield call(aviaBrowserProvider.getPopularFlights, {
            fromId: query.fromId,
            toId: query.toId,
            when: query.when,
            returnDate: query.return_date,
        });

        yield put(flightsFetchActions.success(flights));
    } catch (ex) {
        console.error(ex);
        yield put(flightsFetchActions.failure());
    }
}
