import {ActionType} from 'typesafe-actions';
import {takeLatest, call, put, select} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';

import {ISubscriptionsAnswer} from 'server/api/AviaApi/types/subscriptions';

import {StoreInterface} from 'reducers/storeTypes';
import {initSearchSuccess} from 'reducers/avia/search/results/actions';
import {
    setSubscription,
    resetSubscription,
} from 'reducers/avia/search/subscription/actions';
import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

function* subscription({
    payload: {id: qid},
}: ActionType<typeof initSearchSuccess>) {
    try {
        const userInfo: TUserInfo = yield select(
            (state: StoreInterface) => state.common.userInfo,
        );

        // очищаем информаию о подписке на каждый поиск
        yield put(resetSubscription());

        if (isAuthUser(userInfo)) {
            const {subscribed, id}: ISubscriptionsAnswer = yield call(
                aviaBrowserProvider.subscriptions,
                qid,
            );

            if (subscribed) {
                yield put(setSubscription(id));
            }
        }
    } catch (e) {}
}

export default function* (): SagaIterator {
    yield takeLatest(initSearchSuccess, subscription);
}
