import {put, select, take, takeLatest} from 'redux-saga/effects';
import {getType} from 'typesafe-actions';

import {ESearchFormFieldName} from 'components/SearchForm/types';

import {initSearchDateAction} from 'reducers/buses/search/actions';
import {
    getContextActions,
    setContextValueAction,
} from 'reducers/buses/context/actions';
import {StoreInterface} from 'reducers/storeTypes';
import fillSearchFormThunkAction from 'reducers/buses/search/thunk/fillSearchFormThunkAction';
import requestSearchDateSegmentsThunkAction from 'reducers/buses/search/segments/thunk/requestSearchDateSegmentsThunkAction';
import requestContextAction from 'reducers/buses/context/thunk/requestContextAction';

import {formatDate} from 'utilities/dateUtils';
import {ROBOT} from 'utilities/dateUtils/formats';
import storeSearch from 'projects/index/IndexApp/components/IndexBuses/utilities/storeSearch';
import scrollTo from 'utilities/dom/scrollTo';
import getWhenMoment from 'utilities/dateUtils/when/getWhenMoment';

function* handleInitSearchDate({
    payload,
}: ReturnType<typeof initSearchDateAction>) {
    const {fromSlug, toSlug, originWhen} = payload;

    const {
        buses: {
            context: {value: prevContext},
        },
    }: StoreInterface = yield select();

    scrollTo({top: 0, left: 0});

    if (
        !prevContext ||
        prevContext.from.slug !== fromSlug ||
        prevContext.to.slug !== toSlug
    ) {
        yield put(
            // @ts-ignore redux-saga не понимает, что здесь можно использовать thunk-action
            requestContextAction({
                params: {fromSlug, toSlug, when: originWhen},
            }),
        );

        yield take(getType(getContextActions.success));
    } else if (prevContext.originWhen !== originWhen) {
        yield put(
            setContextValueAction({
                ...prevContext,
                when: formatDate(
                    getWhenMoment(originWhen, prevContext.from.timezone),
                    ROBOT,
                ),
                originWhen,
            }),
        );
    }

    const state: StoreInterface = yield select();

    const {
        buses: {
            context: {value: context},
            searchForm,
        },
    } = state;

    if (!context?.when) {
        return;
    }

    yield put<any>(fillSearchFormThunkAction(context));

    yield put<any>(requestSearchDateSegmentsThunkAction());

    storeSearch({
        from: searchForm[ESearchFormFieldName.FROM],
        to: searchForm[ESearchFormFieldName.TO],
        when: context.when,
    });
}

export default function* initSearchDateSaga() {
    yield takeLatest(getType(initSearchDateAction), handleInitSearchDate);
}
