import {takeEvery, call, put, delay, select} from 'redux-saga/effects';
import {getType} from 'typesafe-actions';
import {SagaIterator} from 'redux-saga';

import {HOUR} from 'utilities/dateUtils/constants';

import {StoreInterface} from 'reducers/storeTypes';
import {ICurrenciesStore} from 'reducers/common/currencies/reducer';
import {currenciesFetchActions} from 'reducers/common/currencies/actions';

import {commonBrowserProvider} from 'serviceProvider/common/commonBrowserProvider';

const ATTEMPTS_COUNT = 5;
const ERROR_DELAY = 3000;
const CURRENCIES_LIFE_TIME = 2 * HOUR;

function* currenciesFetcher(): SagaIterator {
    let attempts = ATTEMPTS_COUNT;

    while (attempts-- > 0) {
        try {
            const {loaded, error, timestamp}: ICurrenciesStore = yield select(
                (store: StoreInterface) => store.common.currencies,
            );
            const lifetime = Date.now() - timestamp;
            const outdate = lifetime > CURRENCIES_LIFE_TIME;

            if (!loaded || error || outdate) {
                const currenciesInfo = yield call(
                    commonBrowserProvider.getCurrenciesInfo,
                );

                yield put(currenciesFetchActions.success(currenciesInfo));
            }

            return;
        } catch (e) {
            yield delay(ERROR_DELAY);
        }
    }
}

export default function* currenciesSaga() {
    yield takeEvery(getType(currenciesFetchActions.request), currenciesFetcher);
}
