import * as currentFormStorage from 'local-storage';
import _get from 'lodash/get';

import {
    PREVIOUS_SEARCH_FORM_STORAGE_PATH,
    PREVIOUS_SEARCH_FORM_STORAGE_VERSION,
} from 'constants/common';

import {IPreviousSearchFormStore} from 'reducers/common/previousSearchForm/types';

export const syncStateWithStorage = (data: IPreviousSearchFormStore): void => {
    const storageValue = {
        version: PREVIOUS_SEARCH_FORM_STORAGE_VERSION,
        data,
    };

    currentFormStorage.set(PREVIOUS_SEARCH_FORM_STORAGE_PATH, storageValue);
};

export const getStateFromStorage = (): IPreviousSearchFormStore => {
    const storageValue = currentFormStorage.get(
        PREVIOUS_SEARCH_FORM_STORAGE_PATH,
    );
    const storageValueVersion = _get(storageValue, 'version');
    const storageFormsValue = _get(storageValue, 'data');

    if (
        storageValueVersion === PREVIOUS_SEARCH_FORM_STORAGE_VERSION &&
        storageFormsValue
    ) {
        return storageFormsValue;
    }

    return {};
};
