import {getType} from 'typesafe-actions';
import {
    delay,
    put,
    select,
    take,
    takeLatest,
    fork,
    cancel,
} from 'redux-saga/effects';
import {SagaIterator, Task} from 'redux-saga';

import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {EActiveHotelSource} from 'types/hotels/hotel/IActiveHotel';

import {setActiveHotel, resetActiveHotel} from 'reducers/favorites/actions';

import {getDefaultActiveHotelPermalink} from 'selectors/favorites/getDefaultActiveHotelPermalink';

function* handleResetSelection() {
    const defaultActiveHotelPermalink: PermalinkType | undefined = yield select(
        getDefaultActiveHotelPermalink,
    );

    if (!defaultActiveHotelPermalink) {
        yield put(setActiveHotel());

        return;
    }

    yield delay(200);
    yield put(
        setActiveHotel({
            permalink: defaultActiveHotelPermalink,
            source: EActiveHotelSource.LIST,
        }),
    );
}

function* handleSelection() {
    try {
        const resetSelectionTask: Task = yield fork(handleResetSelection);

        yield take(getType(setActiveHotel));
        yield cancel(resetSelectionTask);
    } catch (e) {}
}

export default function* (): SagaIterator {
    yield takeLatest(getType(resetActiveHotel), handleSelection);
}
