import {call, put, takeLatest} from 'redux-saga/effects';
import {getType} from 'typesafe-actions';

import {THappyPageOrderInfo} from 'types/happyPage/THappyPageOrderInfo';
import {IErrorResponse} from 'types/common/IErrorResponse';

import {getHappyPageActions} from 'reducers/happyPage/actions';

import {orders as ordersProvider} from 'serviceProvider/orders/orders';

function* handleRequestHappyPage({
    payload,
}: ReturnType<typeof getHappyPageActions.request>) {
    const {orderId, orderType} = payload;

    try {
        const happyPage: THappyPageOrderInfo = yield call(
            ordersProvider.provider().getOrderHappyPage,
            {
                orderId,
                orderType,
            },
        );

        yield put(getHappyPageActions.success(happyPage));
    } catch (err) {
        const {status, statusText} = err?.response || ({} as IErrorResponse);

        yield put(getHappyPageActions.failure({status, statusText}));
    }
}

export default function* requestHappyPageSaga() {
    yield takeLatest(
        getType(getHappyPageActions.request),
        handleRequestHappyPage,
    );
}
