import {takeEvery, call, put} from 'redux-saga/effects';
import {getType} from 'typesafe-actions';
import {SagaIterator} from 'redux-saga';

import {IAppliedPromoCodesInfo} from 'types/hotels/book/IApplyPromoCodes';

import {estimateDiscountActions} from 'reducers/hotels/bookAndPayPage/promoCodesInfo/actions';
import {setBookUserSelectAction} from 'reducers/hotels/bookAndPayPage/bookUserSelectOptions/actions';

import {hotelBookService} from 'serviceProvider';

function* estimateDiscount(
    action: ReturnType<typeof estimateDiscountActions.request>,
) {
    const {payload} = action;

    try {
        const appliedPromoCodes: IAppliedPromoCodesInfo = yield call(
            hotelBookService.provider().estimateDiscount,
            payload,
        );

        yield put(estimateDiscountActions.success(appliedPromoCodes));

        // Если для новой цены рассрочка не доступна, то сбрасываем её
        if (!appliedPromoCodes.deferredPaymentSchedule) {
            yield put(setBookUserSelectAction({useDeferredPayments: false}));
        }
    } catch (e) {
        yield put(estimateDiscountActions.failure());
    }
}

export default function* (): SagaIterator {
    /* Create order watcher */
    yield takeEvery(getType(estimateDiscountActions.request), estimateDiscount);
}
