import {takeEvery, call, put} from 'redux-saga/effects';
import {getType} from 'typesafe-actions';
import {SagaIterator} from 'redux-saga';

import {removeOrderActions} from 'reducers/hotels/bookAndPayPage/orderInfo/actions';
import {fetchOfferInfoByTokenAction} from 'reducers/hotels/bookAndPayPage/offerInfoByToken/actions';
import {resetPromoCodesAction} from 'reducers/hotels/bookAndPayPage/promoCodesInfo/actions';

import {getCSRFTokenHeaderGenerator} from 'utilities/csrfToken/getCSRFTokenHeaderGenerator';

import {hotelBookService} from 'serviceProvider';

function* removeOrder(
    action: ReturnType<typeof removeOrderActions.request>,
): SagaIterator {
    try {
        const csrfTokenHeader = yield call(getCSRFTokenHeaderGenerator);
        const {orderId} = action.payload;

        yield call(
            hotelBookService.provider().removeOrder,
            orderId,
            csrfTokenHeader,
        );

        const {token, label} = action.payload;

        yield put(fetchOfferInfoByTokenAction.request({token, label}));
        yield put(resetPromoCodesAction());

        yield put(removeOrderActions.success());
    } catch (e) {
        yield put(removeOrderActions.failure());
    }
}

export default function* (): SagaIterator {
    yield takeEvery(getType(removeOrderActions.request), removeOrder);
}
