import {takeLatest, put, call, CallEffect} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';
import {getType} from 'typesafe-actions';

import {IGeoRegionInfoRequestParams} from 'server/api/HotelsSearchAPI/types/IGeoRegionInfo';
import {IGeoRegionInfo} from 'types/hotels/geoRegion/IGeoRegionInfo';

import {fetchGeoRegionInfoActions} from 'reducers/hotels/geoRegionPage/actions';

import {hotelsSearchService} from 'serviceProvider';

/* GeoRegionInfo */
const startGeoRegionInfoRequest = function* (
    requestParams: IGeoRegionInfoRequestParams,
): Generator<
    CallEffect<IGeoRegionInfo>,
    IGeoRegionInfo | undefined,
    {data: IGeoRegionInfo}
> {
    const {data} = yield call(
        hotelsSearchService.provider().getGeoRegionInfo,
        requestParams,
    );

    return data;
};

const watchStartFetchGeoRegionInfo = function* (
    action: ReturnType<typeof fetchGeoRegionInfoActions.request>,
): SagaIterator {
    const {payload} = action;

    try {
        const geoRegionInfo = yield call(startGeoRegionInfoRequest, payload);

        yield put(fetchGeoRegionInfoActions.success(geoRegionInfo));
    } catch {
        yield put(fetchGeoRegionInfoActions.failure());
    }
};

/* Total saga */
export default function* (): SagaIterator {
    yield takeLatest(
        getType(fetchGeoRegionInfoActions.request),
        watchStartFetchGeoRegionInfo,
    );
}
