import {
    takeLatest,
    all,
    call,
    take,
    race,
    put,
    delay,
} from 'redux-saga/effects';
import _get from 'lodash/get';
import {SagaIterator} from 'redux-saga';

import {MAIN_TAB_SIMILAR_HOTELS_LIMIT} from 'projects/hotels/constants/hotelPage';

import {HOTEL_INFO_ACTION_TYPES} from 'reducers/hotels/hotelPage/hotelInfo/actionTypes';
import {getSimilarHotelsActions} from 'reducers/hotels/hotelPage/hotelInfo/actions';

import {getSearchParamsByReduxHotelState} from 'projects/hotels/utilities/getHotelPageParams/getSearchParamsByReduxHotelState';
import {
    getOfferAttributionParamsByLocation,
    getHotelOfferToken,
} from 'projects/hotels/utilities/getHotelPageParams/getOfferAttributionParamsByLocation';

import {hotelSearchService} from 'serviceProvider';

const SIMILAR_HOTELS_POLLING_DELAY = 1000;

const startSimilarHotelsPolling = function* (): SagaIterator {
    const offerSearchParamsByHotelInfo = yield call(
        getSearchParamsByReduxHotelState,
    );

    while (true) {
        try {
            const {data} = yield call(
                hotelSearchService.provider().getSimilarHotels,
                {
                    similarHotelLimit: MAIN_TAB_SIMILAR_HOTELS_LIMIT,
                    ...offerSearchParamsByHotelInfo,
                    ...getOfferAttributionParamsByLocation(),
                    ...getHotelOfferToken(),
                },
            );

            const isFinishedPolling = _get(
                data,
                'offerSearchProgress.finished',
            );

            yield put(getSimilarHotelsActions.success(data));

            if (isFinishedPolling) {
                yield put({
                    type: HOTEL_INFO_ACTION_TYPES.STOP_SIMILAR_HOTELS_POLLING,
                });
            } else {
                yield delay(SIMILAR_HOTELS_POLLING_DELAY);
            }
        } catch (e) {
            yield put(getSimilarHotelsActions.failure());
            yield put({
                type: HOTEL_INFO_ACTION_TYPES.STOP_SIMILAR_HOTELS_POLLING,
            });
        }
    }
};

const watchSimilarHotelsPolling = function* () {
    yield race({
        startAction: call(startSimilarHotelsPolling),
        stopAction: take(HOTEL_INFO_ACTION_TYPES.STOP_SIMILAR_HOTELS_POLLING),
    });
};

export default function* (): SagaIterator {
    yield all([
        yield takeLatest(
            HOTEL_INFO_ACTION_TYPES.START_SIMILAR_HOTELS_POLLING,
            watchSimilarHotelsPolling,
        ),
    ]);
}
