import {delay, call, takeLatest, take, race} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';
import {getType} from 'typesafe-actions';

import {
    stopHotelInfoActionsAction,
    syncHotelInfoSearchParamsWithLocation,
} from 'reducers/hotels/hotelPage/hotelInfo/actions';

import updateLocationWithQuery from 'utilities/updateLocationWithQuery/updateLocationWithQuery';
import history from 'utilities/browserHistory/browserHistory';
import {getSearchParamsByReduxHotelState} from 'projects/hotels/utilities/getHotelPageParams/getSearchParamsByReduxHotelState';
import {checkDifferenceBetweenQueryAndSearchParams} from 'projects/hotels/pages/HotelPage/components/HotelPageSearchController/utilities/checkDifferenceBetweenQueryAndSearchParams';
import {getOfferSearchQueryParams} from 'projects/hotels/utilities/getRequiredOfferSearchQuery/getRequiredOfferSearchQuery';

/* Constants */
const SYNC_SEARCH_PARAMS_DELAY = 500;

const syncParamsWithLocation = function* () {
    /* Delay after search request */
    yield delay(SYNC_SEARCH_PARAMS_DELAY);

    /* Sync params with location */
    if (history) {
        const {adults, childrenAges, checkinDate, checkoutDate} =
            yield getSearchParamsByReduxHotelState();

        const offerRequiredSearchParams = {
            adults,
            childrenAges,
            checkinDate,
            checkoutDate,
        };

        const hasDifferenceBetweenQueryAndSearchInfoParams =
            checkDifferenceBetweenQueryAndSearchParams({
                location: history.location,
                searchParams: offerRequiredSearchParams,
            });

        if (hasDifferenceBetweenQueryAndSearchInfoParams) {
            const offerRequiredSearchQueryParams = getOfferSearchQueryParams(
                offerRequiredSearchParams,
            );

            if (offerRequiredSearchQueryParams) {
                yield call(
                    updateLocationWithQuery,
                    offerRequiredSearchQueryParams,
                    history.location,
                    {
                        replace: true,
                        needSaveLocationState: true,
                    },
                );
            }
        }
    }
};

export const watchStartSyncSearchParamsWithLocation = function* () {
    yield race({
        startAction: call(syncParamsWithLocation),
        stopAction: take(getType(stopHotelInfoActionsAction)),
    });
};

export default function* (): SagaIterator {
    yield takeLatest(
        getType(syncHotelInfoSearchParamsWithLocation),
        watchStartSyncSearchParamsWithLocation,
    );
}
