import {takeLatest, call, put} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';

import {LEGACY_HOTEL_INFO_TYPES} from 'reducers/hotels/legacyHotelPage/actionTypes';
import {fetchLegacyHotelInfoActions} from 'reducers/hotels/legacyHotelPage/actions';

import {hotelSearchService} from 'serviceProvider';

const fetchLegacyHotelInfo = function* (
    action: ReturnType<typeof fetchLegacyHotelInfoActions.request>,
) {
    const {payload} = action;

    try {
        const {data} = yield call(
            hotelSearchService.provider().getLegacyHotelInfo,
            payload,
        );

        yield put(fetchLegacyHotelInfoActions.success(data));
    } catch {
        yield put(fetchLegacyHotelInfoActions.failure());
    }
};

export default function* (): SagaIterator {
    yield takeLatest(LEGACY_HOTEL_INFO_TYPES.START, fetchLegacyHotelInfo);
}
