import {GeoIdType} from 'types/hotels/hotel/IGeoRegion';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';

import {StoreInterface} from 'reducers/storeTypes';

import {
    getSearchInfo,
    GetSearchInfoType,
} from 'selectors/hotels/search/searchHotels/getSearchInfo';

export const getOfferRequestParams = (
    reduxState: StoreInterface,
): Partial<IRequiredOfferParams> & {geoId?: GeoIdType} => {
    const searchInfo: ReturnType<GetSearchInfoType> = getSearchInfo(reduxState);

    return {
        ...searchInfo.data?.offerSearchParams,
        geoId: searchInfo.data?.searchRegion?.geoId,
    };
};
