import {Moment} from 'moment';

import getWhenMoment from 'utilities/dateUtils/when/getWhenMoment';

/**
 * Проверяет актуальность даты для поездки
 * @param startDate - дата выезда
 * @param nowMoment - текущий момент времени
 * @link https://st.yandex-team.ru/TRAVELFRONT-6145
 */
export default function isActualStartDate(
    startDate: string | undefined,
    nowMoment: Moment,
): boolean {
    if (!startDate) {
        return false;
    }

    const previousSearchWhenMoment = getWhenMoment(startDate);

    return previousSearchWhenMoment.isSameOrAfter(nowMoment, 'day');
}
