import {Action} from 'redux';
import {select, take} from 'redux-saga/effects';

import diffState, {TStateValue} from 'utilities/state/diffState';

/**
 * Мини-Redux-dev-tools для логирования экшенов, стэйта и изменений в нем в консоль.
 * Решает проблему зависающего reduxDevTools на страницах авиа.
 */
export default function* reduxDevToolsSaga() {
    let prevState: TStateValue;
    let prevTime = new Date();

    while (true) {
        const action: Action = yield take('*');
        const state: TStateValue = yield select();
        const diff = diffState(prevState, state);

        prevState = state;

        const nowTime = new Date();
        const diffTime = nowTime.valueOf() - prevTime.valueOf();

        prevTime = nowTime;

        console.log(
            `action ${action.type} +${diffTime}ms`,
            action,
            '\ndiff',
            diff,
            '\nstate',
            state,
        );
    }
}
