import {all} from 'redux-saga/effects';

import watchOrderDataLoad from 'sagas/trains/watchOrderDataLoad';
import watchPassengersCountChange from 'sagas/trains/watchPassengersCountChange';
import watchOrderUrlRelatedChanges from 'sagas/trains/watchOrderUrlRelatedChanges';
import watchOrderStepChange from 'sagas/trains/watchOrderStepChange';
import watchOrderPayment from 'sagas/trains/watchOrderPayment';
import watchOrderErrors from 'sagas/trains/watchOrderErrors';
import watchOrderAvailability from 'sagas/trains/watchOrderAvailability';
import watchOrderInsuranceIncluded from 'sagas/trains/watchOrderInsuranceIncluded';
import watchTrainsSortingChange from 'sagas/trains/watchTrainsSortingChange';
import watchCoachChange from 'sagas/trains/watchCoachChange';
import watchGenericSearch from 'sagas/trains/watchGenericSearch';
import watchGenericSearchFiltersChange from 'sagas/trains/watchGenericSearchFiltersChange';
import watchPriceCalendar from 'sagas/trains/watchPriceCalendar';

export default function* () {
    yield all([
        watchOrderErrors(),
        watchPassengersCountChange(),
        watchOrderUrlRelatedChanges(),
        watchOrderStepChange(),
        watchOrderPayment(),
        watchOrderDataLoad(),
        watchOrderAvailability(),
        watchOrderInsuranceIncluded(),
        watchTrainsSortingChange(),
        watchCoachChange(),
        watchGenericSearch(),
        watchGenericSearchFiltersChange(),
        watchPriceCalendar(),
    ]);
}
