import {put, select} from 'redux-saga/effects';
import {getType} from 'typesafe-actions';

import {EPlacesView} from 'types/trains/booking/EPlacesView';

import {
    setExpandedServiceClass,
    setPlacesViewType,
} from 'reducers/trains/order/actions/trains';

import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';

import watchActions from 'sagas/trains/helpers/watchActions';

/**
 * Сбрасываем тип отображения мест на дефолтный (вагоны, схема), после
 * Сценарий описан здесь https://st.yandex-team.ru/TRAVELFRONT-3386#5f33cab109c6af1b74f8ca50
 */
function* resetPlacesViewType() {
    const currentSegmentDirectionAndIndex: ReturnType<
        typeof currentSegmentDirectionAndIndexSelector
    > = yield select(currentSegmentDirectionAndIndexSelector);

    yield put(
        setPlacesViewType({
            ...currentSegmentDirectionAndIndex,
            data: EPlacesView.SCHEMAS,
        }),
    );
}

export default function* watchCoachChange() {
    yield watchActions(resetPlacesViewType, [getType(setExpandedServiceClass)]);
}
