import {getType} from 'typesafe-actions';
import {batchActions} from 'redux-batched-actions';
import {call, put, select} from 'redux-saga/effects';

import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import {StoreInterface} from 'reducers/storeTypes';
import {
    setTravelerPassengers,
    setTravelerAccountPassengers,
} from 'reducers/trains/order/actions/traveler';
import {setTrainDetails} from 'reducers/trains/order/actions/trains';
import {setAvailableCountries} from 'reducers/trains/order/actions/data';

import watchActions from 'sagas/trains/helpers/watchActions';

import {getPatchedTravelerPassengers} from 'projects/trains/lib/order/traveler/patchServerResponse/getPatchedTravelerPassengers';
import setVisitParamsInconsistentTariffs from 'projects/trains/lib/order/metrika/setVisitParamsInconsistentTariffs';
import getFirstForwardSegment from 'projects/trains/lib/complexOrder/getFirstForwardSegment';
import getFirstForwardTrainDetails from 'projects/trains/lib/complexOrder/getFirstForwardTrainDetails';
import getFirstForwardTrain from 'projects/trains/lib/complexOrder/getFirstForwardTrain';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import {accountService} from 'serviceProvider';
import {trainsBrowserProvider} from 'serviceProvider/trains/trainsBrowserProvider';

function* watcher() {
    try {
        const {
            common: {userInfo},
            trains: {order},
        }: StoreInterface = yield select((store: StoreInterface) => store);

        const segment = getFirstForwardSegment(order);
        const trainDetailsInfo = getFirstForwardTrain(order)?.trainDetails;
        const trainDetails = getFirstForwardTrainDetails(order);

        if (!trainDetails || trainDetailsInfo?.errors || !segment) {
            return;
        }

        // TODO: elyoskin - убрать после экспа или заменить на другой вариант
        if (!order.availableCountries.length) {
            const {countries} = yield call(trainsBrowserProvider.countries);

            yield put(setAvailableCountries(countries));
        }

        // Отправка в метрику статистики о несовпадении тарифов на выдаче и на покупке
        yield call(
            setVisitParamsInconsistentTariffs,
            trainDetails.coaches ?? [],
            segment,
        );

        if (isAuthUser(userInfo)) {
            const passengersWithDocuments: IPassengerWithDocumentsAndBonusCardsDTO[] =
                yield call(
                    accountService.provider()
                        .getPassengersWithDocumentsAndBonusCards,
                );

            // Устанавливаем данные из записной книжки
            yield put(
                batchActions(
                    [
                        setTravelerAccountPassengers(passengersWithDocuments),
                        setTravelerPassengers(
                            getPatchedTravelerPassengers(
                                passengersWithDocuments,
                            ),
                        ),
                    ].filter(Boolean),
                ),
            );
        }
    } catch (err) {
        console.error('trains watchOrderDataLoad', err);
    }
}

export default function* watchOrderDataLoad() {
    yield watchActions(watcher, [getType(setTrainDetails)]);
}
