import {call, select} from 'redux-saga/effects';
import {getType, ActionType} from 'typesafe-actions';
import {SagaIterator} from 'redux-saga';

import {IMetrikaTrainsOrderErrorParams} from 'utilities/metrika/types/params/trains';

import {setOrderError} from 'reducers/trains/order/actions/view';

import {orderStepSelector} from 'selectors/trains/order/orderStepSelector';

import watchActions from 'sagas/trains/helpers/watchActions';

import {params} from 'utilities/metrika';

function* logOrderErrors(action: ActionType<typeof setOrderError>) {
    const {payload} = action;

    if (payload) {
        const {type, data, message} = payload;
        const orderStep: ReturnType<typeof orderStepSelector> = yield select(
            orderStepSelector,
        );

        yield call(params, {
            trains: {
                order_error: {
                    [orderStep]: {
                        [type]:
                            data && data.code
                                ? `${data.code}: ${message}`
                                : message,
                    },
                },
            },
        } as {trains: IMetrikaTrainsOrderErrorParams});
    }
}

export default function* watchOrderErrors(): SagaIterator {
    yield call(watchActions, logOrderErrors, [getType(setOrderError)]);
}
