import {select, put} from 'redux-saga/effects';
import {getType} from 'typesafe-actions';

import {TrainsInsuranceStatus} from 'server/api/TrainsBookingApi/types/TrainsInsuranceStatus';

import {setOrderInfo} from 'reducers/trains/order/actions/data';
import {setInsuranceIncluded} from 'reducers/trains/order/actions/userChoice';

import trainsOrderSelector from 'selectors/trains/order/trainsOrderSelector';

import watchActions from 'sagas/trains/helpers/watchActions';

import {getFirstTrainService} from 'projects/trains/lib/complexOrder/getFirstTrainService';

function* handleOrderInfoChanges() {
    const {
        insuranceIncluded,
        orderInfo,
    }: ReturnType<typeof trainsOrderSelector> = yield select(
        trainsOrderSelector,
    );
    const trainService = getFirstTrainService(orderInfo);

    if (
        insuranceIncluded ||
        !trainService ||
        [
            TrainsInsuranceStatus.CHECKOUT_FAILED,
            TrainsInsuranceStatus.PRICED,
            TrainsInsuranceStatus.DISABLED,
        ].includes(trainService.trainInfo.insuranceStatus)
    ) {
        return;
    }

    yield put(setInsuranceIncluded(true));
}

export default function* watchOrderInsuranceIncluded() {
    yield watchActions(handleOrderInfoChanges, [getType(setOrderInfo)]);
}
