import {getType} from 'typesafe-actions';
import {select, call} from 'redux-saga/effects';

import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';

import {setSorting} from 'reducers/trains/search/actions/sorting';
import {StoreInterface} from 'reducers/storeTypes';

import watchActions from 'sagas/trains/helpers/watchActions';

import history from 'utilities/browserHistory/browserHistory';
import getTrainsSortingQuery from 'projects/trains/lib/sort/getTrainsSortingQuery';
import updateLocationWithQuery from 'utilities/updateLocationWithQuery/updateLocationWithQuery';

function* handleTrainsSortingChange() {
    const {
        trains: {
            context,
            search: {sort},
        },
    } = yield select((store: StoreInterface) => store);

    if (!isFilledTrainsSearchContext(context) || !history) {
        return;
    }

    yield call(() => {
        if (!history) {
            return;
        }

        updateLocationWithQuery(getTrainsSortingQuery(sort), history.location, {
            replace: true,
            needSaveLocationState: true,
            scrollTop: 0,
        });
    });
}

export default function* watchTrainsSortingChange() {
    yield watchActions(handleTrainsSortingChange, [getType(setSorting)]);
}
