import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

const getDocs = (state: StoreInterface): {passengerId: string}[] => {
    return state.account.documents;
};

const getUserId = (state: StoreInterface, props: {userId: string}): string => {
    return props ? props.userId : '';
};

export default createSelector([getDocs, getUserId], (docs, id) =>
    docs.filter(item => item.passengerId === id),
);
