import {StoreInterface} from 'reducers/storeTypes';

import actionsStatusesSelector from 'selectors/account/order/trains/actionsStatusesSelector';

import {STATUS} from 'projects/account/lib/orders/actionsStatuses';

/**
 * Общий статус по обновлению и возврату
 * @param state
 */
export default function actionsStatusSelector(state: StoreInterface): STATUS {
    const {updateStatus, refundStatus} = actionsStatusesSelector(state);

    if (refundStatus === STATUS.PENDING || updateStatus === STATUS.PENDING) {
        return STATUS.PENDING;
    }

    if (refundStatus === STATUS.REJECT || updateStatus === STATUS.REJECT) {
        return STATUS.REJECT;
    }

    return STATUS.NULL;
}
