import {TrainsInsuranceStatus} from 'server/api/TrainsBookingApi/types/TrainsInsuranceStatus';

import {StoreInterface} from 'reducers/storeTypes';

import trainServicesSelector from 'selectors/account/order/trains/trainServicesSelector';

export default function hasInsuranceSelector(state: StoreInterface): boolean {
    const services = trainServicesSelector(state);

    return services.some(
        service =>
            service.trainInfo.insuranceStatus ===
            TrainsInsuranceStatus.CHECKED_OUT,
    );
}
