import {createSelector} from 'reselect';

import trainServicesSelector from 'selectors/account/order/trains/trainServicesSelector';

const hasNonRefundableTariffSelector = createSelector(
    [trainServicesSelector],
    services => {
        return services.some(service =>
            service.trainInfo.passengers.some(
                passenger => passenger.nonRefundableTariff,
            ),
        );
    },
);

export default hasNonRefundableTariffSelector;
