import {createSelector} from 'reselect';

import ERefundPartState from 'server/api/GenericOrderApi/types/common/refund/ERefundPartState';
import {isNotNull} from 'types/utilities';
import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';

import trainServicesSelector from 'selectors/account/order/trains/trainServicesSelector';

interface ITicketsInService {
    serviceId: string;
    tickets: ITrainTicket[];
}

/**
 * Билеты, которые можно вернуть по услугам
 */
const notRefundedTicketsInServicesSelector = createSelector(
    [trainServicesSelector],
    (services): ITicketsInService[] => {
        return services.map(service => {
            const {
                trainInfo: {passengers},
                id,
            } = service;

            const tickets = passengers
                .filter(
                    passenger =>
                        passenger?.refundPartInfo?.state ===
                        ERefundPartState.ENABLED,
                )
                .map(passenger => passenger.ticket)
                .filter(isNotNull);

            return {
                serviceId: id,
                tickets,
            };
        });
    },
);

export default notRefundedTicketsInServicesSelector;
