import {createSelector} from 'reselect';
import flatMap from 'lodash/flatMap';

import ITrainTicket from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainTicket';

import notRefundedTicketsInServicesSelector from './notRefundedTicketsInServicesSelector';

/**
 * Билеты, которые можно вернуть во всех услугах заказа
 */
const notRefundedTicketsSelector = createSelector(
    [notRefundedTicketsInServicesSelector],
    (notRefundedTicketsInServices): ITrainTicket[] => {
        return flatMap(
            notRefundedTicketsInServices,
            serviceTickets => serviceTickets.tickets,
        );
    },
);

export default notRefundedTicketsSelector;
