import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

import {StoreInterface} from 'reducers/storeTypes';

import {trainsOrderSelector} from 'selectors/account/order/trains/trainsOrderSelector';

import normalizeGenericOrderState from 'projects/trains/lib/api/utilities/normalizeGenericOrderState';

export default function orderStateSelector(
    state: StoreInterface,
): EGenericOrderState {
    const order = trainsOrderSelector(state);

    return normalizeGenericOrderState(order?.state);
}
