import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

import {StoreInterface} from 'reducers/storeTypes';

import orderStateSelector from 'selectors/account/order/trains/orderStateSelector';

import {ORDER_STATUS_VALUES} from 'projects/account/lib/orders/statuses';

export default function orderStatusSelector(
    state: StoreInterface,
): ORDER_STATUS_VALUES {
    const orderState = orderStateSelector(state);

    switch (orderState) {
        case EGenericOrderState.CONFIRMED:
        case EGenericOrderState.REFUNDED:
            return ORDER_STATUS_VALUES.DONE;

        case EGenericOrderState.NEW:
        case EGenericOrderState.IN_PROGRESS:
        case EGenericOrderState.STARTING_PAYMENT:
            return ORDER_STATUS_VALUES.PROGRESS;

        case EGenericOrderState.RESERVED:
        case EGenericOrderState.WAITING_PAYMENT:
            return ORDER_STATUS_VALUES.RESERVED;

        case EGenericOrderState.PAYMENT_FAILED:
        case EGenericOrderState.CANCELLED:
            return ORDER_STATUS_VALUES.CANCELLED;

        default:
            return ORDER_STATUS_VALUES.PROGRESS;
    }
}
