import flatMap from 'lodash/flatMap';
import {createSelector} from 'reselect';

import {isNotUndefined} from 'types/utilities';

import trainServicesSelector from 'selectors/account/order/trains/trainServicesSelector';

import IPrice from 'utilities/currency/PriceInterface';
import sumPrice from 'utilities/price/sumPrice';

/**
 * Возвраты приходится складывать по пассажирам,
 * в ответе нет поля, где лежит общий возврат по заказу
 */
const orderTotalRefundAmountSelector = createSelector(
    [trainServicesSelector],
    (services): IPrice | undefined => {
        const passengers = flatMap(
            services,
            service => service.trainInfo.passengers,
        );
        const refundAmounts = passengers
            .map(
                passenger =>
                    passenger?.refundPartInfo?.refund?.refundAmount ??
                    undefined,
            )
            .filter(isNotUndefined);

        if (!refundAmounts.length) {
            return;
        }

        return sumPrice(...refundAmounts);
    },
);

export default orderTotalRefundAmountSelector;
