import {createSelector} from 'reselect';

import {isNotUndefined} from 'types/utilities';

import trainServicesSelector from 'selectors/account/order/trains/trainServicesSelector';

const partnerReservationNumbersSelector = createSelector(
    [trainServicesSelector],
    (services): string[] => {
        return services
            .map(service => service.trainInfo.reservationNumber)
            .filter(isNotUndefined);
    },
);

export default partnerReservationNumbersSelector;
