import ITrainPassenger from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainPassenger';

import {StoreInterface} from 'reducers/storeTypes';

import {trainsOrderSelector} from 'selectors/account/order/trains/trainsOrderSelector';

import {getFirstTrainService} from 'projects/trains/lib/complexOrder/getFirstTrainService';

export const passengerByBlankIdFromGenericOrder = (
    state: StoreInterface,
    blankId: string,
): ITrainPassenger | undefined => {
    const order = trainsOrderSelector(state);
    const trainService = getFirstTrainService(order);

    return trainService?.trainInfo.passengers.find(
        p => String(p.ticket?.blankId) === blankId,
    );
};
