import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';

import {StoreInterface} from 'reducers/storeTypes';

import {passengerByBlankIdFromGenericOrder} from 'selectors/account/order/trains/passengerByBlankIdFromGenericOrder';
import {trainsOrderTypeSelector} from 'selectors/account/ordersSelector';

/**
 * Возвращает ссылку на "Скачать чек" в возврате у пассажира в ЖД заказе
 * по blankId
 * @param state
 * @param blankId
 */
export const paymentRefundReceiptUrlByBlankIdSelector = (
    state: StoreInterface,
    blankId: string,
): string | undefined => {
    const trainsOrderType = trainsOrderTypeSelector(state);

    if (trainsOrderType !== ORDER_TYPE_VALUES.TRAINS_GENERIC) {
        return;
    }

    const passenger = passengerByBlankIdFromGenericOrder(state, blankId);

    return passenger?.refundPartInfo?.refund?.paymentRefundReceiptUrls?.[0];
};
