import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';
import ITrainsDownloadBlankApiParams from 'server/api/TrainsBookingApi/types/ITrainsDownloadBlankApiParams';

import {StoreInterface} from 'reducers/storeTypes';

import {trainsOrderSelector} from 'selectors/account/order/trains/trainsOrderSelector';
import {passengerByBlankIdFromGenericOrder} from 'selectors/account/order/trains/passengerByBlankIdFromGenericOrder';
import {trainsOrderTypeSelector} from 'selectors/account/ordersSelector';

import getGenericDownloadBlankUrl from 'projects/account/pages/Order/utilities/downloadBlank/getGenericDownloadBlankUrl';
import getDownloadBlankUrl from 'projects/account/pages/Order/utilities/downloadBlank/getDownloadBlankUrl';

/**
 * Получаем ссылку на Скачать квитанцию (КРС)
 * @param state
 * @param blankId
 */
export const refundBlankUrlByBlankIdSelector = (
    state: StoreInterface,
    blankId: string,
): string | null => {
    const trainsOrderType = trainsOrderTypeSelector(state);
    const genericOrder = trainsOrderSelector(state);

    if (!genericOrder) {
        return null;
    }

    const orderId = genericOrder.id;

    if (trainsOrderType === ORDER_TYPE_VALUES.TRAINS_GENERIC) {
        const passenger = passengerByBlankIdFromGenericOrder(state, blankId);

        const token = passenger?.refundPartInfo?.refund?.refundBlankToken;

        if (!token || !genericOrder) {
            return null;
        }

        return getGenericDownloadBlankUrl({token, orderId});
    }

    const params: ITrainsDownloadBlankApiParams = {
        id: orderId,
        blankId,
    };

    return getDownloadBlankUrl(params, trainsOrderType);
};
