import {createSelector} from 'reselect';

import IPrice from 'types/common/price/IPrice';

import refundAmountSelector from 'selectors/account/order/trains/refundAmountSelector';
import penaltyAmountSelector from 'selectors/account/order/trains/penaltyAmountSelector';

import {CurrencyType} from 'utilities/currency/CurrencyType';

const totalAmountByRefundAndPenaltySelector = createSelector(
    [refundAmountSelector, penaltyAmountSelector],
    (refundAmount, penaltyAmount): IPrice | null => {
        if (refundAmount?.value && penaltyAmount?.value) {
            return {
                value: refundAmount.value + penaltyAmount.value,
                currency: CurrencyType.RUB,
            };
        }

        if (refundAmount?.value) {
            return refundAmount;
        }

        return null;
    },
);

export default totalAmountByRefundAndPenaltySelector;
