import {createSelector} from 'reselect';

import {ITrainGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';

import {trainsOrderSelector} from 'selectors/account/order/trains/trainsOrderSelector';

import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';

const trainServicesSelector = createSelector(
    [trainsOrderSelector],
    (order): ITrainGenericService[] => {
        return getTrainServices(order);
    },
);

export default trainServicesSelector;
